<?php

namespace apexl\Io\modules\display\components\form;

use apexl\Io\modules\component\entities\componentEntity;

class FormGroup extends componentEntity
{
    public function __construct()
    {
        parent::__construct();
        $this->setName('FormGroup');
    }

    public function addComponent(componentEntity $componentEntity): static
    {
        if (method_exists($componentEntity, 'setFormId') && $this->props->get('formId')) {
            $componentEntity->setFormId($this->props->get('formId')->value);
        }
        parent::addComponent($componentEntity);

        return $this;
    }

    public function setFormId(string $formId)
    {
        $this->addProperty('formId', $formId);
        return $this;
    }

    public function addField(componentEntity $field)
    {
        $this->addComponent($field);
        return $this;
    }

}
