<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class DisplayTable extends Component
{
    protected $displayData;

    public function __construct()
    {
        parent::__construct();
    }

    public function addTitle($title)
    {
        $this->setProperty('title', $title);
        return $this;
    }

    public function addData($title, $data = null, $component = null)
    {
        $display = [];
        $display['title'] = $title;
        if ($data) {
            $display['content'] = $data;
        }
        if ($component) {
            $display['component'] = (string) $component;
        }
        $this->displayData[] = (object) $display;
        $this->setProperty('data', $this->displayData);
        return $this;
    }
}
