<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class Menu extends Component
{
    private const string PROP__MENU_ITEMS = 'menuItems';
    private const string PROP__TITLE = 'title';

    public function addMenuItems(array $menuItems): static
    {
        return $this->setProperty(self::PROP__MENU_ITEMS, $menuItems);
    }

    public function setTitle(string $title): static
    {
        return $this->setProperty(self::PROP__TITLE, $title);
    }
}
