<?php

namespace apexl\Io\modules\display;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\display\controllers\dashboardController;
use apexl\Io\modules\display\controllers\formsController;
use apexl\Io\modules\display\hooks\redirectFollowingEntityDeleteHook;
use apexl\Io\modules\display\hooks\setDefaultRenderDisplaysHook;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;
use apexl\Io\modules\user\classes\userManagedDisplayModule;
use apexl\Io\modules\user\enums\permissions\Common;
use app\vendor\apexl\io\src\Io\interfaces\ProvidesHooksInterface;

class displayModule extends userManagedDisplayModule implements ProvidesHooksInterface, ProvidesRoutesInterface
{
    public function initialise(): void
    {
        parent::initialise();
        $this->setBaseRoute(sprintf('/display/v%s/universal', $this->apiVersion()));
    }

    public function routes(RouteManager $routeManager): void
    {
        //base pages
        $this->addProtectedRootRoute(
            $routeManager,
            HttpMethod::GET,
            'home',
            '/',
            dashboardController::class,
            Common::IS_LOGGED_IN
        );
        //base forms
        $this->addProtectedFormRoute(
            $routeManager,
            'form.universal.entity.delete',
            'entities/{entity}/{id}/delete',
            [formsController::class, 'entityDelete'],
        );
    }

    public function hooks(): array
    {
        return [
            setDefaultRenderDisplaysHook::class,
            redirectFollowingEntityDeleteHook::class,
        ];
    }
}
