<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\includes\Entity;

readonly class CardEntityFilteredDisplayTable extends EntityFilteredDisplayTable
{

    public function __construct(Entity $entity = null, $replacements = [], $withButtons = true, $buttonFormat = 'buttons')
    {
        parent::__construct($entity, $replacements, $withButtons, $buttonFormat);
        $this->setName('CardDataTable');
        $this->setProperty('supportComponentLocation', 'header');
    }

    public function addTitle($title)
    {
        $this->setProperty('title', $title);
        return $this;
    }

    public function setFilterFormLocation($location)
    {
        if (in_array($location, ['header', 'body'])) {
            $this->setProperty('filterFormLocation', $location);
        }
        return $this;
    }

}
