<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly final class FilterableMenus extends Component
{
    private const string PROP__MENUS = 'menus';
    private const string PROP__FILTERABLE = 'filterable';

    public function setMenus(array $menus): FilterableMenus
    {
        return $this->setProperty(self::PROP__MENUS, $menus);
    }

    public function setFilterable(bool $filterable): FilterableMenus
    {
        return $this->setProperty(self::PROP__FILTERABLE, $filterable);
    }
}