<?php

namespace apexl\Io\modules\display\components;

use apexl\Config\Singleton;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\component\Component\Component;

readonly class MessageList extends Component
{
    public function __construct(private readonly RouteManager $routeManager) {}

    public function setItems($messages): static
    {
        $this->setProperty('messages', $messages);

        return $this;
    }

    public function addConfirmButton($route, $text, $class = ""): static
    {
        if ($url = $this->routeManager->getRoutePattern($route)) {
            $this->setProperty(
                'confirmButtonUrl',
                sprintf('%s%s', config('app.site.backend_domain'), $url)
            );
            $this->setProperty('confirmButtonText', $text);
            if ($class) $this->setProperty('confirmButtonClass', $class);
        }

        return $this;
    }


}
