<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class Chart extends Component
{
    public function __construct()
    {
        parent::__construct();
        $this->setChartType('Line');
    }

    public function setChartType($type)
    {
        $this->setProperty('chartType', $type);
        return $this;
    }

    public function setChartData($data)
    {
        $this->setProperty('chartData', $data);
        return $this;
    }

    public function setChartLabels($labels, $generateRandomColours = true)
    {
        $this->setProperty('chartLabels', $labels);
        if ($generateRandomColours) {
            $this->setChartColours($this->generateRandomColoursArray(count($labels)));
        }
        return $this;
    }

    public function setChartColours($colours)
    {
        $this->setProperty('chartColours', $colours);
        return $this;
    }

    protected function generateRandomColoursArray($length)
    {
        $colours = [];
        for ($i = 0; $i < $length; $i++) {
            $colours[] = sprintf('#%06X', mt_rand(0, 0xFFFFFF));
        }

        return $colours;
    }
}