<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class LinkTile extends Component
{
    public function __construct()
    {
        parent::__construct();
        $this->setColWidth('sm', 3);
        $this->setColWidth('md', 2);
        $this->addRoute('/');
        $this->addText('');
        $this->addIcon('link');
    }

    public function addRoute($route)
    {
        $this->setProperty('route', $route);
        return $this;
    }

    public function addText($text)
    {
        $this->setProperty('text', $text);
        return $this;
    }

    public function addIcon($icon)
    {
        $this->setProperty('icon', $icon);
        return $this;
    }

    public function isExternal($external = true)
    {
        $this->setProperty('external', $external);
        return $this;
    }

    public function addTarget($target)
    {
        $this->setProperty('target', $target);
        return $this;
    }
}
