<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class ProgressBar extends Component
{
    public function __construct()
    {
        parent::__construct();
        $this->activeStage(0);
        $this->addStages(['Start', 'Middle', 'End']);
        $this->showLabels(true);
    }

    public function activeStage(int $activeStage)
    {
        $this->setProperty('activeStage', $activeStage);
        return $this;
    }

    public function addStages(array $stages)
    {
        $this->setProperty('stages', $stages);
        return $this;
    }

    public function showLabels(bool $showLabels)
    {
        $this->setProperty('showLabels', $showLabels);
        return $this;
    }
}