<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

class genericComponents
{
    public static function pageWrapper($pageContent) {}

    public static function componentWrapper($classes = '')
    {
        $contentCentre = new Component();
        $contentCentre->setName('ComponentWrapper');
        $contentCentre->classes = $classes;
        return $contentCentre;
    }

    /**
     * @param $imgSrc
     * @param string $classes
     * @param string $id
     * @return Component
     */
    public static function imageTile($imgSrc, $id = 'imageTile', $classes = 'col-md-12')
    {
        $imageTile = new Component();
        $imageTile->setId($id);
        $imageTile->setName('ImageTile');
        $imageTile->classes = $classes;
        $imageTile->setProperty('imgSrc', $imgSrc);
        $imageTile->setProperty('href', '/');

        return $imageTile;
    }

    /**
     * @param $name
     * @param $dataSrc
     * @param string $classes
     * @return Component
     */
    public static function formTile($name, $dataSrc, $classes = 'col-md-6')
    {
        $form = new Component();
        $form->setId($name);
        $form->setName('Form');
        $form->classes = $classes;
        $form->setProperty('dataSrc', $dataSrc);

        return $form;
    }

    /**
     * @param $dataSrc
     * @param string $classes
     * @param bool $withCommonButtons //Edit and delete buttons by row
     * @param bool $editRole
     * @param bool $deleteRole
     * @param null $buttonBaseRoute
     * @param bool $viewButton
     * @return Component
     */
    public static function dataTable($dataSrc, $classes = '', $withCommonButtons = false, $editRole = false, $deleteRole = false, $buttonBaseRoute = null, $viewButton = true)
    {
        $currentUser = $this->currentUserFactory->get();
        $DataTable = new Component();
        $DataTable->setName('DataTable');
        $DataTable->classes = $classes;

        $DataTable->setProperty(
            'dataSrc',
            $dataSrc . (str_contains((string) $dataSrc, '?') ? '&asTable=1' : '?asTable=1')
        );

        if (str_contains((string) $dataSrc, '?')) {
            list($dataSrc) = explode('?', (string) $dataSrc);
        }
        if ($withCommonButtons) {
            $dataSrc = $buttonBaseRoute ?? $dataSrc;
            if ($access = ($viewButton ? $currentUser->isAllowed($viewButton) : false)) {
                $DataTable->addComponent(
                    genericComponents::tableButton($dataSrc, 'eye', '', 'table__btn table__btn-view', 'view')
                );
            }
            if ($access = ($editRole ? $currentUser->isAllowed($editRole) : false)) {
                $editProcessButton = genericComponents::tableButton(
                    $dataSrc,
                    'edit',
                    '',
                    'table__btn table__btn-edit',
                    'edit'
                );
                $editProcessButton->verb = 'post'; //this is a post route, so update it.
                $DataTable->addComponent($editProcessButton);
            }
            if ($access = ($deleteRole ? $currentUser->isAllowed($deleteRole) : false)) {
                $deleteProcessButton = genericComponents::tableButton(
                    $dataSrc,
                    'trash',
                    '',
                    'table__btn table__btn-delete',
                    'delete'
                );
                $deleteProcessButton->verb = 'post'; //this is a post route, so update it.
                $DataTable->addComponent($deleteProcessButton);
            }
        }

        return $DataTable;
    }

    public static function tableButton($route, $icon = null, $text = '', $classes = '', $event = '')
    {
        $tile = new Component();
        $tile->setId($id ?? $tile->id);
        $tile->setName('TableButton');
        $tile->classes = $classes;
        $tile->setProperty('route', $route);
        $tile->setProperty('icon', $icon);
        $tile->setProperty('text', $text);
        $tile->setProperty('event', $event);

        return $tile;
    }

    public static function headerBar() {}

    public static function linkTile($route, $icon = 'link', $text = '', $id = null, $classes = 'col-md-4', $asString = true)
    {
        $tile = (new LinkTile())->addRoute($route)->addText($text)->addIcon($icon)->addClass($classes);
        if ($asString) {
            return (string) $tile;
        }
        return $tile;
    }

    public static function linkButton($route, $text, $type = 'primary', $icon = '', $id = null)
    {
        $tile = new Component();
        $tile->setId($id ?? $tile->id);
        $tile->setName('ButtonTile');
        $tile->classes = 'btn btn-' . $type;
        $tile->setProperty('route', $route);
        $tile->setProperty('icon', $icon);
        $tile->setProperty('text', $text);

        return $tile;
    }

    public static function contentWrapper($content)
    {
        $contentWrapper = new Component();
        $contentWrapper->setName('ContentWrapper');
        if (!empty($content)) {
            foreach ($content as $component) {
                $contentWrapper->addComponent($component);
            }
        }
        return $contentWrapper;
    }

    public static function ContentTitle($title, $content = '', $headerSize = 3, $classes = '')
    {
        $contentTitle = new Component();
        $contentTitle->setName('ContentTitle');
        $contentTitle->classes = $classes;
        $contentTitle->setProperty('title', $title);
        $contentTitle->setProperty('content', $content);
        $contentTitle->setProperty('header', $headerSize);
        return $contentTitle;
    }

    public static function dashboardBlockWrapper($components = [], $classes = 'col-md-6 col-sm-12 data-tile')
    {
        $tileContentWrapper = genericComponents::rowWrapper('content-wrapper');
        foreach ($components as $component) {
            $tileContentWrapper->addComponent($component);
        }

        $tileWrapper = genericComponents::rowWrapper($classes);
        $tileWrapper->addComponent($tileContentWrapper);
        return $tileWrapper;
    }

    public static function rowWrapper($classes)
    {
        $rowWrapper = new Component();
        $rowWrapper->setName('RowWrapper');
        $rowWrapper->classes = $classes;
        return $rowWrapper;
    }

    public static function simpleButtonLink($route, $text, $icon = false, $classes = false)
    {
        $simpleButtonLink = new Component();
        $simpleButtonLink->setName('SimpleButton');
        $simpleButtonLink->classes = 'button-link';
        $simpleButtonLink->setProperty('route', $route);
        $simpleButtonLink->setProperty('text', $text);
        if ($icon) {
            $simpleButtonLink->icon = $icon;
        }
        if ($classes) {
            $simpleButtonLink->classes = $classes;
        }
        return $simpleButtonLink;
    }

    public static function listTile($title, $content, $headerSize = 3, $classes = '')
    {
        $listTitle = new Component();
        $listTitle->setName('ListTile');
        $listTitle->classes = $classes;
        $listTitle->setProperty('title', $title);
        $listTitle->setProperty('content', $content);
        $listTitle->setProperty('header', $headerSize);

        return $listTitle;
    }
}
