<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\includes\RouteManager;
use apexl\Io\modules\component\Component\Component;

readonly class BasicTable extends Component
{
    protected array $data;
    protected bool $hideDisabled = false;

    public function __construct($data, private readonly RouteManager $routeManager)
    {
        parent::__construct();
        $this->addData($data);
    }

    public function addData($data)
    {
        $this->setProperty('data', $data);
        return $this;
    }

    public function colspans($colspans = [])
    {
        $this->setProperty('colspans', $colspans);
        return $this;
    }

    public function hideIdColumn($display = true)
    {
        $this->setProperty('hideIdColumn', $display);
        return $this;
    }

    public function addViewButton($routeName, $disabled = false)
    {
        $this->addButton($routeName, 'eye', $disabled);
        return $this;
    }

    public function addButton($routeName, $icon = '', $disabled = false)
    {
        $BEM = str_replace('Entity', '', (string) $this->entity->getEntityName());
        $button = (new TableButton())
            ->addRoute($this->routeManager->getRoutePattern($routeName, [], false))
            ->addIcon($icon)
            ->addClass($BEM . '_table__btn')
            ->addClass($BEM . '_table__btn-' . $icon);
        if ($disabled) {
            $button->addRoute('#');
            $button->addClass($BEM . '_table__btn-disabled');
            if ($this->hideDisabled) {
                //do not add the button to the component
                return $this;
            }
        }
        $this->addComponent($button);
        return $this;
    }

    public function addEditButton($routeName, $disabled = false)
    {
        $this->addButton($routeName, 'edit', $disabled);
        return $this;
    }

    public function addDeleteButton($routeName, $disabled = false)
    {
        $this->addButton($routeName, 'trash', $disabled);
        return $this;
    }

    public function hideDisabled($value = true)
    {
        $this->hideDisabled = $value;
        return $this;
    }
}
