<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class CardTile extends Component
{
    public function __construct()
    {
        parent::__construct();

    }

    public function addTitle($title)
    {
        $this->setProperty('title', $title);
        return $this;
    }

    public function addHeaderModal($modalTitle, $contentComponents, $icon = 'circle-question')
    {
        $modal = (new Modal())->setButtonContent('<i class="fa-regular fa-circle-question"></i>')->addComponents(
            $contentComponents
        )->setTitle($modalTitle)->addClass('modal-help');
        $this->addSupportComponent($modal);
        return $this;
    }

    public function addDataSrc($src, $allowRefresh = true)
    {
        $this->setProperty('contentSrc', $src);
        if ($allowRefresh) {
            $this->setProperty('refreshButton', '<i class="fa-light fa-arrows-rotate"></i>');
        }
        return $this;
    }

}
