<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class ContentTitle extends Component
{
    public function init(?string $title = null, ?string $content = null, ?int $headerNum = null)
    {
        if ($title) {
            $this->addTitle($title);
        }

        if ($content) {
            $this->addContent($content);
        }

        $this->addHeader($headerNum ?? 3);
    }

    public function addTitle($text): ContentTitle
    {
        $this->setProperty('title', $text);

        return $this;
    }

    public function addContent($text): ContentTitle
    {
        $this->setProperty('content', $text);

        return $this;
    }

    public function addHeader($num): ContentTitle
    {
        $this->setProperty('header', $num);

        return $this;
    }
}
