<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class FileButton extends Component
{
    public function __construct()
    {
        parent::__construct();
        $this->addRoute('/');
        $this->addText('');
    }

    public function addRoute($route)
    {
        $this->setProperty('route', $route);
        return $this;
    }

    public function addText($text)
    {
        $this->setProperty('text', $text);
        return $this;
    }

    public function addIcon($icon)
    {
        $this->setProperty('icon', $icon);
        return $this;
    }

    public function disabled($disabled = FALSE)
    {
        $this->setProperty('disabled', $disabled);
        return $this;
    }

}