<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class Modal extends Component
{
    public function __construct()
    {
        parent::__construct();
        $this->addClass('button-link');
    }

    public function setTitle($title)
    {
        $this->setProperty('title', $title);
        return $this;
    }

    public function setModalId($modalId)
    {
        $this->setProperty('modalId', $modalId);
        return $this;
    }

    public function setButtonContent($content)
    {
        $this->setProperty('buttonContent', $content);
        return $this;
    }

    public function setButtonClass($class)
    {
        $this->setProperty('buttonClass', $class);
        return $this;
    }

    public function setContentSrc($src, $data = [], $stripTags = false)
    {
        $this->setProperty('contentSrc', $this->routeManager->getRoutePattern($src, $data, $stripTags));
        return $this;
    }

    public function setRowConditional($if)
    {
        $this->setProperty('if', $if);
        return $this;
    }
}
