<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Collections\ComponentCollection;
use apexl\Io\modules\component\Collections\ComponentPropertyCollection;
use apexl\Io\modules\component\Component\Component;
use apexl\Io\modules\component\Factories\ComponentPropertyFactory;
use apexl\Io\modules\component\Factories\GenericComponentFactory;
use Arrayy\Type\StringCollection;

;

readonly final class NoUIWrapper extends Component
{
    public const string NAME = 'ComponentWrapper';
    private RowWrapper $wrapper;
    private ComponentWrapper $componentWrapper;

    public function __construct(
        GenericComponentFactory $componentFactory,
        ComponentPropertyFactory $propertyFactory,
        ComponentPropertyCollection $props,
        ComponentCollection $components,
        StringCollection $classes
    ) {
        parent::__construct($propertyFactory, $props, $components, $classes);
        $this->wrapper = $componentFactory->make(RowWrapper::class);
        $this->componentWrapper = $componentFactory->make(ComponentWrapper::class);
    }

    public function init(): void
    {
        $this->addClass('h-100')
            ->addClass('page-no-layout');

        //rely on object inheritance to allow us to continue to manipulate the wrapper.
        $this->componentWrapper
            ->addComponent($this->wrapper)
            ->addClass('row');

        $this->__addComponent($this->componentWrapper);
    }

    public function addComponent(Component $component): static
    {
        $this->wrapper->addComponent($component);

        return $this;
    }

    /**
     * We need to maintain this functionality internally, but override it for the component.
     */
    protected function __addComponent(Component $componentEntity): NoUIWrapper
    {
        $this->components->set($componentEntity->id, $componentEntity);

        return $this;
    }
}
