<?php

namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\Component\Component;

readonly class SimpleButton extends Component
{
    public function __construct()
    {
        parent::__construct();
        $this->addClass('button-link');
    }

    public function addRoute($route)
    {
        $this->setProperty('route', $route);
        return $this;
    }

    public function addText($text)
    {
        $this->setProperty('text', $text);
        return $this;
    }

    public function addIcon($icon)
    {
        $this->setProperty('icon', $icon);
        return $this;
    }

    public function disabled($disabled = false)
    {
        $this->setProperty('disabled', $disabled);
        return $this;
    }
}
