<?php

namespace apexl\Io\modules\display\pages;

use apexl\Io\modules\display\includes\Page;
use apexl\Io\modules\display\regions\NoUIContentRegion;
use apexl\Io\modules\display\regions\PageContentRegion;
use apexl\Io\services\VariableManager;

/**
 * Class blankPage
 * A blank page with no UI, only a content region.
 * @package apexl\Io\modules\display\pages
 */
class blankPage extends Page
{
    public function __construct(private VariableManager $variableManager)
    {
        parent::__construct();
    }

    public function addToContent(array $components, ?int $weight = null): static
    {
        $this->addToRegion($components, NoUIContentRegion::class, $weight);

        return $this;
    }

    protected function buildRegions(): void
    {
        $this->globalRegion = new PageContentRegion()
            ->addWrapperClass($this->variableManager->get('noui_page_global_classes') ?? 'h-100');

        $this->globalRegion->addRegions([
            new NoUIContentRegion(),
        ]);
    }
}
