<?php

namespace apexl\Io\modules\display\components;

use apexl\Config\Singleton;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\component\Collections\ComponentCollection;
use apexl\Io\modules\component\Collections\ComponentPropertyCollection;
use apexl\Io\modules\component\Component\Component;
use apexl\Io\modules\component\Factories\ComponentPropertyFactory;
use Arrayy\Type\StringCollection;
use function apexl\Io\config;

readonly class MessageList extends Component
{
    public function __construct(
        private RouteManager $routeManager,
        ComponentPropertyFactory $propertyFactory,
        ComponentPropertyCollection $props,
        ComponentCollection $components,
        StringCollection $classes,
        ?string $componentId = null
    ) {
        parent::__construct(
            $propertyFactory,
            $props,
            $components,
            $classes,
            $componentId
        );
    }

    public function setItems($messages): static
    {
        $this->setProperty('messages', $messages);

        return $this;
    }

    public function addConfirmButton($route, $text, $class = ""): static
    {
        if ($url = $this->routeManager->getRoutePattern($route)) {
            $this->setProperty(
                'confirmButtonUrl',
                sprintf('%s%s', config('app.site.backend_domain'), $url)
            );
            $this->setProperty('confirmButtonText', $text);
            if ($class) $this->setProperty('confirmButtonClass', $class);
        }

        return $this;
    }


}
