<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\ComponentFactory;

use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\display\components\Menu;
use function apexl\Io\assertInstanceOf;

final readonly class MenuComponentFactory
{
    public function __construct(private GenericComponentFactory $componentFactory) {}

    public function make(array $menuItems = [], string $title = '', string $menuClass = Menu::class): Menu
    {
        assertInstanceOf($menuClass, Menu::class);

        /** @var Menu $menu */
        $menu = $this->componentFactory->make($menuClass);

        $menu->addMenuItems($menuItems);
        if ($title) {
            $menu->setTitle($title);
        }

        return $menu;
    }
}