<?php

namespace apexl\Io\modules\display\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\component\Interfaces\ComponentInterface;
use apexl\Io\modules\display\services\Render;
use apexl\Io\services\Output;


readonly class DisplayController extends Controller
{
    public function __construct(
        private GenericComponentFactory $componentFactory,
        protected Render $render,
        Output $output,
    ) {
        parent::__construct($output);
    }

    protected function component(string $class, array $initParams = [], array $constructorParams = []): ComponentInterface
    {
        return $this->componentFactory->make($class, $initParams, $constructorParams);
    }
}
