<?php

declare(strict_types=1);

namespace apexl\Io\modules\display\hooks;

use apexl\Io\interfaces\AbstractHook;
use apexl\Io\modules\display\Collections\PageRegistry;
use apexl\Io\modules\display\pages\blankPage;
use apexl\Io\modules\display\pages\genericPageLeftMenu;
use apexl\Io\modules\display\pages\noUIiframeFlow;
use apexl\Io\modules\display\services\Render;

final readonly class setDefaultRenderDisplaysHook implements AbstractHook
{
    public function hooks(): array
    {
        return [Render::HOOK__COLLECT_PAGES];
    }

    public function __invoke(
        PageRegistry $pages,
    ): void {
        //only apply a default if it hasn't already been done.
        if (!$pages->has(Render::DEFAULT_PAGE_KEY)) {
            $pages->set(Render::DEFAULT_PAGE_KEY, genericPageLeftMenu::class);
        }
        if (!$pages->has('noUI')) {
            $pages->set('noUI', blankPage::class);
        }
        if (!$pages->has('noUIiframe')) {
            $pages->set('noUIiframe', noUIiframeFlow::class);
        }
    }

}
