<?php

namespace apexl\Io\modules\display\controllers;

use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class dashboardController
{
    protected $render;
    protected $currentUser;

    public function __construct(Render $render, currentUser $currentUser)
    {
        $this->currentUser = $currentUser::getCurrentUser();
        $this->render = $render;
    }

    public function dashboard(Request $request, Response $response)
    {
        //allow modules to add things to the dashboard through hooks -- we need to have this route by default or nothing works!
        //@todo better routing overrides?
        $components = Hook::processHook('genericWrapperAlter', [], 'DashboardHomeAlter');
        return System::asJson($response, $this->render::build([$components]));
    }
}
