<?php
namespace apexl\Io\modules\display\components;

use apexl\Io\includes\Routes;
use apexl\Io\modules\component\entities\componentEntity;

class BasicTable extends componentEntity {

    protected $data;
    protected $hideDisabled = FALSE;

    public function __construct($data)
    {
        parent::__construct();
        $this->addData($data);
    }

    public function addData($data){
        $this->addProperty('data', $data);
        return $this;
    }

    public function colspans($colspans = []){
        $this->addProperty('colspans', $colspans);
        return $this;
    }

    public function hideIdColumn($display = TRUE){
        $this->addProperty('hideIdColumn', $display);
        return $this;
    }

    public function addViewButton($routeName, $disabled = FALSE){
        $this->addButton($routeName, 'eye', $disabled);
        return $this;
    }

    public function addEditButton($routeName, $disabled = FALSE){
        $this->addButton($routeName, 'edit', $disabled);
        return $this;
    }

    public function addDeleteButton($routeName, $disabled = FALSE){
        $this->addButton($routeName, 'trash', $disabled);
        return $this;
    }

    public function addButton($routeName, $icon ='', $disabled = FALSE){
        $BEM = str_replace('Entity', '', $this->entity->getEntityName());
        $button = (new TableButton())
            ->addRoute(Routes::getRoutePattern($routeName, [], FALSE))
            ->addIcon($icon)
            ->addClass($BEM.'_table__btn')
            ->addClass($BEM.'_table__btn-'.$icon);
        if($disabled) {
            $button->addRoute('#');
            $button->addClass($BEM . '_table__btn-disabled');
            if($this->hideDisabled){
                //do not add the button to the component
                return $this;
            }
        }
        $this->addComponent($button);
        return $this;
    }

    public function hideDisabled($value = TRUE){
        $this->hideDisabled = $value;
        return $this;
    }
}