<?php
namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\menu\entities\menuEntity;

class DropdownMenu extends componentEntity {
    public function __construct()
    {
        parent::__construct();
        $this->setName('SimpleDropdownMenu');
    }

    public function addMenuByName($name){
        $menuEntity = new menuEntity();
        $menuEntity->loadByName($name);
        $this->addProperty('menuItems', $menuEntity->getAllItemsAsMenu($this->currentUser));
        return $this;
    }

    public function addMenuItems($items){
        $this->addProperty('menuItems', $items);
        return $this;
    }

    public function addTitle($title){
        $this->addProperty('menuTitle', $title);
        return $this;
    }

    public function addIcon($icon){
        $this->addProperty('menuIcon', $icon);
        return $this;
    }
}