<?php
namespace apexl\Io\modules\display\components;

use apexl\Io\modules\component\entities\componentEntity;
use apexl\Io\modules\user\services\currentUser;

class genericComponents {

    public static function pageWrapper($pageContent){

    }

    public static function componentWrapper($classes = ''){
        $contentCentre = new componentEntity();
        $contentCentre->name = 'ComponentWrapper';
        $contentCentre->classes = $classes;
        return $contentCentre;
    }

    /**
     * @param $imgSrc
     * @param string $classes
     * @param string $id
     * @return componentEntity
     */
    public static function imageTile($imgSrc, $id = 'imageTile', $classes = 'col-md-12'){
        $imageTile = new componentEntity();
        $imageTile->id = $id;
        $imageTile->name = 'ImageTile';
        $imageTile->classes = $classes;
        $imageTile->addProperty('imgSrc', $imgSrc);
        $imageTile->addProperty('href', '/');

        return $imageTile;
    }

    /**
     * @param $name
     * @param $dataSrc
     * @param string $classes
     * @return componentEntity
     */
    public static function formTile($name, $dataSrc, $classes = 'col-md-6'){
        $form = new componentEntity();
        $form->id = $name;
        $form->name = 'Form';
        $form->classes = $classes;
        $form->addProperty('dataSrc', $dataSrc);

        return $form;
    }

    /**
     * @param $dataSrc
     * @param string $classes
     * @param bool $withCommonButtons //Edit and delete buttons by row
     * @param bool $editRole
     * @param bool $deleteRole
     * @param null $buttonBaseRoute
     * @param bool $viewButton
     * @return componentEntity
     */
    public static function dataTable($dataSrc, $classes = '', $withCommonButtons = FALSE, $editRole = FALSE, $deleteRole = FALSE, $buttonBaseRoute = NULL, $viewButton = TRUE){
        $currentUser = currentUser::getCurrentUser();
        $DataTable = new componentEntity();
        $DataTable->name = 'DataTable';
        $DataTable->classes = $classes;

        $DataTable->addProperty('dataSrc', $dataSrc.(strpos($dataSrc, '?') !== FALSE ? '&asTable=1' : '?asTable=1'));

        if(strpos($dataSrc, '?') !== FALSE) {
            list($dataSrc) = explode('?', $dataSrc);
        }
        if($withCommonButtons){
            $dataSrc = $buttonBaseRoute ?? $dataSrc;
            if($access = ($viewButton ? $currentUser->isAllowed($viewButton) : FALSE)) {
                $DataTable->addComponent(genericComponents::tableButton($dataSrc, 'eye', '', 'table__btn table__btn-view', 'view'));
            }
            if($access = ($editRole ? $currentUser->isAllowed($editRole) : FALSE)) {
                $editProcessButton = genericComponents::tableButton($dataSrc, 'edit', '', 'table__btn table__btn-edit', 'edit');
                $editProcessButton->verb = 'post'; //this is a post route, so update it.
                $DataTable->addComponent($editProcessButton);
            }
            if($access = ($deleteRole ? $currentUser->isAllowed($deleteRole) : FALSE)) {
                $deleteProcessButton = genericComponents::tableButton($dataSrc, 'trash', '', 'table__btn table__btn-delete', 'delete');
                $deleteProcessButton->verb = 'post'; //this is a post route, so update it.
                $DataTable->addComponent($deleteProcessButton);
            }
        }

        return $DataTable;
    }

    public static function tableButton($route, $icon = NULL, $text = '', $classes = '', $event = ''){
        $tile = new componentEntity();
        $tile->id = $id ?? $tile->id;
        $tile->name = 'TableButton';
        $tile->classes = $classes;
        $tile->addProperty('route', $route);
        $tile->addProperty('icon', $icon);
        $tile->addProperty('text', $text);
        $tile->addProperty('event', $event);

        return $tile;
    }

    public static function headerBar(){

    }

    public static function linkTile($route, $icon = 'link', $text = '', $id = NULL, $classes = 'col-md-4', $asString = TRUE){
        $tile = (new LinkTile())->addRoute($route)->addText($text)->addIcon($icon)->addClass($classes);
        if($asString) {
            return (string) $tile;
        }
        return $tile;
    }

    public static function linkButton($route, $text, $type = 'primary', $icon = '', $id = NULL){
        $tile = new componentEntity();
        $tile->id = $id ?? $tile->id;
        $tile->name = 'ButtonTile';
        $tile->classes = 'btn btn-'.$type;
        $tile->addProperty('route', $route);
        $tile->addProperty('icon', $icon);
        $tile->addProperty('text', $text);

        return $tile;
    }

    public static function contentWrapper($content){
        $contentWrapper = new componentEntity();
        $contentWrapper->name = 'ContentWrapper';
        if(!empty($content)) {
            foreach ($content as $component) {
                $contentWrapper->addComponent($component);
            }
        }
        return $contentWrapper;
    }

    public static function ContentTitle($title, $content = '', $headerSize = 3, $classes = ''){
        $contentTitle = new componentEntity();
        $contentTitle->name = 'ContentTitle';
        $contentTitle->classes = $classes;
        $contentTitle->addProperty('title', $title);
        $contentTitle->addProperty('content', $content);
        $contentTitle->addProperty('header', $headerSize);
        return $contentTitle;
    }

    public static function rowWrapper($classes){
        $rowWrapper = new componentEntity();
        $rowWrapper->name = 'RowWrapper';
        $rowWrapper->classes = $classes;
        return $rowWrapper;
    }

    public static function dashboardBlockWrapper($components = [], $classes = 'col-md-6 col-sm-12 data-tile'){
        $tileContentWrapper = genericComponents::rowWrapper('content-wrapper');
        foreach($components as $component) {
            $tileContentWrapper->addComponent($component);
        }

        $tileWrapper = genericComponents::rowWrapper($classes);
        $tileWrapper->addComponent($tileContentWrapper);
        return $tileWrapper;
    }

    public static function simpleButtonLink($route, $text, $icon = FALSE, $classes = FALSE){
        $simpleButtonLink = new componentEntity();
        $simpleButtonLink->name = 'SimpleButton';
        $simpleButtonLink->classes = 'button-link';
        $simpleButtonLink->addProperty('route', $route);
        $simpleButtonLink->addProperty('text', $text);
        if($icon) {
            $simpleButtonLink->icon = $icon;
        }
        if($classes) {
            $simpleButtonLink->classes = $classes;
        }
        return $simpleButtonLink;
    }

    public static function listTile($title, $content, $headerSize = 3, $classes = ''){
        $listTitle = new componentEntity();
        $listTitle->name = 'ListTile';
        $listTitle->classes = $classes;
        $listTitle->addProperty('title', $title);
        $listTitle->addProperty('content', $content);
        $listTitle->addProperty('header', $headerSize);

        return $listTitle;
    }
}