<?php

namespace apexl\Io\modules\display\components\form;

use apexl\Io\modules\component\entities\componentEntity;

abstract class BaseField extends componentEntity
{

    protected $validations = [];

    public function setFormId(string $formId)
    {
        $this->addProperty('formId', $formId);
        return $this;
    }

    public function setFieldName(string $fieldName)
    {
        $this->addProperty('fieldName', $fieldName);
        $this->addProperty('id', $fieldName); // Default id to fieldname
        return $this;
    }

    public function setValue($value)
    {
        $this->addProperty('value', $value);
        return $this;
    }

    public function setLabel(string $label)
    {
        $this->addProperty('label', $label);
        return $this;
    }

    public function isRequired()
    {
        $this->addProperty('required', true);
        $this->addValidation('required', []);
        return $this;
    }

    public function setPlaceholder(string $text)
    {
        $this->addProperty('placeholder', $text);
        return $this;
    }

    public function isDisabled($isDisabled)
    {
        if ($isDisabled) {
            $this->addProperty('disabled', (bool)$isDisabled);
        }
        return $this;
    }

    public function addValidation($method, $config)
    {
        $this->validations[] = (object)array_merge(['method' => $method], $config);
        $this->addProperty('validations', $this->validations);
        return $this;
    }

    public function setLength($length)
    {
        $this->addProperty('length', $length);
        return $this;
    }

}
