<?php

namespace apexl\Io\modules\emailDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\display\components\BasicLink;
use apexl\Io\modules\display\components\ButtonBar;
use apexl\Io\modules\display\components\CardEntityFilteredDisplayTable;
use apexl\Io\modules\display\components\ColWrapper;
use apexl\Io\modules\display\components\ContentTitle;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\EntityDisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\components\Iframe;
use apexl\Io\modules\display\components\RowWrapper;
use apexl\Io\modules\display\components\SimpleButton;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\email\entities\emailEntity;
use apexl\Io\modules\email\services\emailService;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\productDisplay\components\primaryButtons;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class emailController extends Controller
{
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
    }

    public function list(Request $request, Response $response, $args)
    {
        $this->render::setPageTitle('Email Log');

        $params = [];

        /*$helpComponents = [
            (new ContentTitle())->addClass('text-black text-start help-modal-content-title')->addTitle('A list of emails sent out by the system'),
            (new DisplayTable())->addClass('text-black text-start help-modal-display-table')->addRows([
                ['Invoice Date', 'Date the Invoice was raised.'],
                ['Invoice No.', 'Reference'],
                ['Customer', 'Customer email address'],
                ['Type', 'Whether this invoice was for a Purchase or Subscription'],
                ['Total', 'Total value of invoice, excluding VAT'],
                ['VAT', 'VAT due on the goods/services purchased'],
                ['Paid', 'Whether the invoice has been paid (yes/no)'],
                ['Last Payment Attempt', 'The last time an attempt was made to collect payment for this invoice'],
                //['Abandoned?', 'Whether this invoice has been marked as abandoned'],
            ])
        ];*/

        $wrapper = (new ColWrapper())
            ->addClass('col-12')
            ->addComponent((new CardEntityFilteredDisplayTable())
                ->addTitle('Email Log')
                ->setFilters('orderBy[]=timestamp&orderBy[]=DESC')
                ->addFilterForm('emails.form.emaillog.filter')
                ->setFilterFormLocation('body')
                ->src(Routes::getRoutePattern('email.data.basic').'?'. http_build_query($params))
                ->displayPagination(true, false, true, 'inside')
                ->displayShortTotals(false)
                ->addProperty('refreshButton', '<i class="fa-light fa-arrows-rotate"></i>')
                ->hideIdColumn()
                ->setRefreshTag('email-log-table')
                //->addHeaderModal('Email Log', $helpComponents)
                ->addDropMenuModal('View / Resend', 'Resend Email', [], 'emailDisplay.resend')
            );

        $this->output::addResponse($request, $this->render::build([$wrapper]));
        return System::asJson($response);
    }

    public function sendEmail(Request $request, Response $response, $args)
    {
        $form = (new FormComponent())->setID('sendEmail')->src(Routes::getRoutePattern('emails.form.compose', $args));
        $this->render::setActive("modal");
        $this->output::addResponse($request, $this->render::build($form));

        return System::asJson($response);
    }

    public function resendEmail(Request $request, Response $response, $args)
    {

        $emailService = new emailService();
        $emailEntity = $emailService->loadPreviousEmail($args['id']);

        $colWrapper = (new ColWrapper())
            ->addClass('text-center')
            ->addComponent(
                (new Iframe())
                    ->addClass('w-100 resend-iframe')
                    ->setSrcdoc($emailEntity->config->body)
            )
            ->addComponent(
                (new SimpleButton())
                    ->addRoute(Routes::getRoutePattern('email.resend', ['id' => $emailEntity->id]) )
                    ->addText('Resend Now')
                    ->addClass('btn btn-primary btn-lg text-center mt-3')
                    ->addProperty('asynch', 'POST')
            )
        ;
        $this->render::setActive("modal");
        $this->output::addResponse($request, $this->render::build($colWrapper));

        return System::asJson($response);
    }

    public function composeForm(Request $request, Response $response, $args)
    {
        $form = new formEntity();
        $form->setActionUrl(Routes::getRoutePattern('email.send'));

        // Company Name
        $form->addField((new inputField('toEmail'))->setLabel("To:")->setPlaceholder('name@example.com (comma-separated list)')->isRequired());
        $form->addField((new inputField('ccEmail'))->setLabel("Cc:")->setPlaceholder('name2@example.com (comma-separated list)'));
        $form->addField((new inputField('subject'))->setLabel("Subject:")->isRequired());
        $form->addField((new textareaField('message'))->setLabel('Message:')->addClass('col')->setRows(10)->isRequired());

        return System::asJson($response, $form->getBuiltFormArray(), 200);
    }

    public function emailLogFilterForm(Request $request, Response $response, $args)
    {
        $form = new formEntity();
        $form->setId('emailLogFilter');
        $form->addClass('filter-form');
        $form->setMethod('post');
        $form->setActionUrl(Routes::getRoutePattern('email.data.basic'));
        $form->setSubmitText('Search');
        $form->includeClearButton()->setClearButtonText('Reset filters');

        $form->addFieldToGroup((new inputField('recipient'))->setLabel('Email')->setInputType('text')->setPlaceholder('Email'), 'emaillog_filters');

        return System::asJson($response, $form->getBuiltFormArray());
    }
}
