<?php

namespace apexl\Io\modules\email\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\System;
use apexl\Io\modules\display\includes\Forms;
use apexl\Io\modules\email\services\templateService;
use apexl\Io\services\Mailer;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class emailController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function submitEmail(Request $request, Response $response, $args)
    {
        $body = $request->getParsedBody();

        $from = $this->config->app->site->email_address ?? 'no-reply@localhost.com';
        $fromName = $this->config->app->site->name ?? 'localhost';

        $mailer = new Mailer();
        $mailer->setFrom($from, $fromName);

        $toParts = array_filter(explode(",", $body->toEmail));
        $ccParts = array_filter(explode(",", $body->ccEmail));

        // *** Validation ***
        $errors = [];
        foreach ($toParts as $email) {
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $errors[] = "Please ensure all provided email addresses are valid";
            }
        }
        foreach ($ccParts as $email) {
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $errors[] = "Please ensure all provided email addresses are valid";
            }
        }
        if (trim($body->subject) == "") {
            $errors[] = "Subject is required";
        }
        if (count($errors) > 0) {
            $this->output::addMessage('email.send', 'error', implode("<br>", $errors));
            return System::asJson($response);
        }
        // *** End Validation ***

        foreach ($toParts as $email) {
            $mailer->addAddress($email); // Add a recipient
        }
        foreach ($ccParts as $email) {
            $mailer->addCC($email); // Add a recipient
        }

        $mailer->Subject = $body->subject;
        $mailer->Body = templateService::fetch("generic", [
            'subject' => $body->subject,
            'message' => $body->message,
        ]);
        $mailer->IsHTML(true);
        $result = $mailer->send();
        if ($result) {
            $this->output::addMessage('email.send', 'success', "You successfully sent a branded email to {$body->toEmail}");
            $this->output::addMetadata('email.send', 'events', [(object)['name' => 'closeModal', 'value' => true]]);
        } else {
            $this->output::addMessage('email.send', 'error', "Message failed to send");
        }

        return System::asJson($response, ['sent' => $result]);
    }


}
