<?php

namespace apexl\Io\modules\emailDisplay\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Routes;
use apexl\Io\includes\System;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\display\components\ButtonBar;
use apexl\Io\modules\display\components\CardEntityFilteredDisplayTable;
use apexl\Io\modules\display\components\DisplayTable;
use apexl\Io\modules\display\components\EntityFilteredDisplayTable;
use apexl\Io\modules\display\components\FormComponent;
use apexl\Io\modules\display\components\genericComponents;
use apexl\Io\modules\display\services\Render;
use apexl\Io\modules\formbuilder\entities\formEntity;
use apexl\Io\modules\formbuilder\includes\checkboxField;
use apexl\Io\modules\formbuilder\includes\inputField;
use apexl\Io\modules\formbuilder\includes\textareaField;
use apexl\Io\modules\user\entities\userEntity;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class emailController extends Controller
{
    protected $render;

    public function __construct(Render $render)
    {
        parent::__construct();
        $this->render = $render;
    }

    public function sendEmail(Request $request, Response $response, $args)
    {
        $form = (new FormComponent())->setID('sendEmail')->src(Routes::getRoutePattern('emails.form.compose', $args));
        $this->render::setActive("modal");
        $this->output::addResponse($request, $this->render::build($form));

        return System::asJson($response);
    }

    public function composeForm(Request $request, Response $response, $args)
    {
        $form = new formEntity();
        $form->setActionUrl(Routes::getRoutePattern('email.send'));

        // Company Name
        $form->addField((new inputField('toEmail'))->setLabel("To:")->setPlaceholder('name@example.com (comma-separated list)')->isRequired());
        $form->addField((new inputField('ccEmail'))->setLabel("Cc:")->setPlaceholder('name2@example.com (comma-separated list)'));
        $form->addField((new inputField('subject'))->setLabel("Subject:")->isRequired());
        $form->addField((new textareaField('message'))->setLabel('Message:')->addClass('col')->setRows(10)->isRequired());

        return System::asJson($response, $form->getBuiltFormArray(), 200);
    }
}
