<?php

namespace apexl\Io\modules\emailDisplay;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\modules\company\callbacks\accessControl;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\companyDisplay\callbacks\displayFormRender;
use apexl\Io\modules\companyDisplay\callbacks\redirects;
use apexl\Io\modules\companyDisplay\controllers\companyController;
use apexl\Io\modules\companyDisplay\controllers\formsController;
use apexl\Io\modules\emailDisplay\controllers\emailController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\userDisplay\userDisplayModule;

class emailDisplayModule extends userDisplayModule
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {

        $this->addProtectedAdminRootRoute('GET', 'emailDisplay.compose', 'compose', emailController::class.':sendEmail', 'administer');

        //forms
        $this->addProtectedFormRoute('emails.form.compose', 'compose-email', emailController::class.':composeForm', 'administer');

    }


}
