<?php

namespace apexl\Io\modules\email\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\includes\System;
use apexl\Io\modules\display\includes\Forms;
use apexl\Io\modules\email\entities\emailEntity;
use apexl\Io\modules\email\services\emailService;
use apexl\Io\modules\email\services\templateService;
use apexl\Io\modules\invoice\entities\invoiceEntity;
use apexl\Io\modules\product\entities\productEntity;
use apexl\Io\modules\subscription\services\subscriptionService;
use apexl\Io\modules\user\entities\userEntity;
use apexl\Io\modules\user\services\currentUser;
use apexl\Io\services\Mailer;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

class emailController extends Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function emailListTableDataBasic(Request $request, Response $response, $args)
    {
        $params = $request->getQueryParams();
        $currentUser = currentUser::getCurrentUser();
        $entity = new emailEntity();
        $filters = $this->buildFilterConditions($entity, $params);

        $entityData = $entity->loadByPage($params, $filters, $params['orderBy'] ?? []);

        //$emails = $entity->loadMultiple($filters, $params['orderBy'] ?? [], $params['limit'], $params['offset']); // Note - this inclueds access control with correct config

        $entityData['tableHeader'] = ['id', 'Sent', 'Subject', 'Recipient', 'Status', 'Error'];

        $rows = [];

        foreach($entityData['data'] as $email){
            $email = (object)$email;
            $emailDate = \DateTime::createFromFormat('Y-m-d H:i:s', $email->timestamp);
            $config = json_decode($email->config);

            $row = [
                'id' => $email->id,
                'submitted' => $emailDate->format('H:i \o\n jS M Y'),
                'subject' => $email->subject,
                'to' => $config->to,
                'sent' => $email->sent == '1' ? '<span class="badge bg-success">sent</span>' : '<span class="badge bg-danger">not sent</span>',
                'error' => $email->error,
            ];

            $rows[] = $row;
        }

        $entityData['rows'] = $rows;
        $entityData['totalData'] = count($rows);
        unset($entityData['data']);

        return System::asJson($response, $entityData);
    }

    public function buildFilterConditions($entity, $params, $validFields = []): array
    {
        $filters = parent::buildFilterConditions($entity, $params, []);
        if(isset($filters['recipient'])) {
            $filters['recipient'][1] = '%' . $filters['recipient'][1] . '%';
            $filters['recipient'][2] = 'LIKE';
        }

        return $filters;
    }


    public function submitEmail(Request $request, Response $response, $args)
    {
        $body = $request->getParsedBody();

        $toParts = array_filter(explode(",", $body->toEmail));
        $ccParts = array_filter(explode(",", $body->ccEmail));

        // *** Validation ***
        $errors = [];
        foreach ($toParts as $email) {
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $errors[] = "Please ensure all provided email addresses are valid";
            }
        }
        foreach ($ccParts as $email) {
            if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $errors[] = "Please ensure all provided email addresses are valid";
            }
        }
        if (trim($body->subject) == "") {
            $errors[] = "Subject is required";
        }
        if (count($errors) > 0) {
            $this->output::addMessage('email.send', 'error', implode("<br>", $errors));
            return System::asJson($response);
        }
        // *** End Validation ***

        $emailService = new emailService();
        $result = $emailService->send(
            (object) [
                'to' => $body->toEmail,
                'cc' => $body->ccEmail,
                'subject' => $body->subject,
                'body' => templateService::fetch("generic", [
            'subject' => $body->subject,
            'message' => $body->message,
                ]),
                'user_id' => 0,
            ],
            'generic_email'
        );

        if ($result) {
            $this->output::addMessage('email.send', 'success', "You successfully sent a branded email to {$body->toEmail}");
            $this->output::addMetadata('email.send', 'events', [(object)['name' => 'closeModal', 'value' => true]]);
        } else {
            $this->output::addMessage('email.send', 'error', "Message failed to send");
        }

        return System::asJson($response, ['sent' => $result]);
    }

    public function resendEmail(Request $request, Response $response, $args)
    {
        $emailService = new emailService();
        $emailEntity = $emailService->loadPreviousEmail($args['id']);

        $result = $emailService->send($emailEntity->config, $emailEntity->template_name);

        if ($result) {
            $this->output::addMessage('email.send', 'success', "You successfully resent an email to {$emailEntity->config->to}");
            $this->output::addMetadata('email.send', 'events', [(object)['name' => 'closeModal', 'value' => true]]);
            $this->output::addMetadata('email.send1', 'refreshByTag', ['email-log-table']);
        } else {
            $this->output::addMessage('email.send', 'error', "Message failed to send");
        }

        return System::asJson($response, ['sent' => $result]);
    }

}
