<?php

namespace apexl\Io\modules\emailDisplay;

use apexl\Io\includes\Controller;
use apexl\Io\includes\Hook;
use apexl\Io\modules\company\callbacks\accessControl;
use apexl\Io\modules\company\entities\companyEntity;
use apexl\Io\modules\companyDisplay\callbacks\displayFormRender;
use apexl\Io\modules\companyDisplay\callbacks\redirects;
use apexl\Io\modules\companyDisplay\controllers\companyController;
use apexl\Io\modules\companyDisplay\controllers\formsController;
use apexl\Io\modules\email\entities\emailEntity;
use apexl\Io\modules\emailDisplay\controllers\emailController;
use apexl\Io\modules\menu\services\Menu;
use apexl\Io\modules\userDisplay\userDisplayModule;

class emailDisplayModule extends userDisplayModule
{
    public function __construct()
    {
        parent::__construct();
    }

    public function routes()
    {

        $this->addProtectedEntityRoutes((new emailEntity()), [
            'all' => [emailController::class.':list', 'administer'],
            //'get' => [companyController::class.':view', 'ViewCoreCompanies'],
            //'put' => [companyController::class.':create', 'UpdateCoreCompany'],
            //'post' => [companyController::class.':create', 'CreateCoreCompany'],
            //'delete' => [Controller::class.':delete', 'DeleteCoreCompany'],
        ]);

        $this->addProtectedAdminRootRoute('GET', 'emailDisplay.compose', 'compose', emailController::class.':sendEmail', 'administer');
        $this->addProtectedAdminRootRoute('GET', 'emailDisplay.resend', 'resend/{id}', emailController::class.':resendEmail', 'administer');

        //forms
        $this->addProtectedFormRoute('emails.form.compose', 'compose-email', emailController::class.':composeForm', 'administer');
        $this->addProtectedFormRoute('emails.form.resend', 'resend-email/{id}', emailController::class.':composeForm', 'administer');


        $this->addProtectedFormRoute('emails.form.emaillog.filter', 'emaillog-filter', emailController::class.':emailLogFilterForm', 'administer');

    }


}
