<?php

declare(strict_types=1);

namespace apexl\Io\modules\email\services;

use apexl\Config\Singleton;
use apexl\Io\includes\System;
use apexl\Io\modules\email\entities\emailEntity;
use apexl\Io\services\Logger;
use apexl\Io\services\Mailer;
use mikehaertl\wkhtmlto\Pdf;

class emailService
{

    protected static $smtpDebug = '';

    public static function addDebug($level, $str)
    {
        self::$smtpDebug .= "$level: $str\n";
    }

    protected static function resetDebug()
    {
        self::$smtpDebug = '';
    }

    /**
     * @param array<string, string> $replacements
     */
    public static function send($config, $templateName)
    {
        try {
            if (isset($config->attachments) && is_iterable($config->attachments)) {
                $attachments = $config->attachments;
                unset($config->attachments);
            }

            $emailEntity = new emailEntity();
            $emailEntity->recipient = $config->to ?? "";
            $emailEntity->timestamp = date('Y-m-d H:i:s');
            $emailEntity->user_id = $config->userId ?? 0;
            $emailEntity->template_name = $templateName;
            $emailEntity->subject = $config->subject ?? null;
            $emailEntity->config = json_encode($config);
            $emailEntity->sent = 0;
            $emailEntity->store();

            $mailer = new Mailer();

            $ioConfig = Singleton::getInstance();

            $config->from = $config->from ?? ($ioConfig->app->site->email_address ?? 'no-reply@localhost.com');
            $config->fromName = $config->fromName ?? ($ioConfig->app->site->name ?? 'localhost');

            $mailer->setFrom($config->from, $config->fromName);

            $toParts = array_filter(explode(",", $config->to));
            $ccParts = array_filter(explode(",", ($config->cc ?? '')));
            $bccParts = array_filter(explode(",", ($config->bcc ?? '')));

            foreach ($toParts as $email) {
                $mailer->addAddress($email);
            }
            foreach ($ccParts as $email) {
                $mailer->addCC($email);
            }
            foreach ($bccParts as $email) {
                $mailer->addBCC($email);
            }

            $mailer->Subject = $config->subject;
            $mailer->Body = $config->body;
            $mailer->IsHTML(true);

            if (isset($attachments)) {
                foreach ($attachments as $attachment) {
                    $mailer->addStringAttachment($attachment->content, $attachment->filename);
                }
            }
            $mailer->SMTPDebug = 3;
            self::resetDebug();
            $mailer->Debugoutput = __NAMESPACE__ .'\emailService::addDebug';

            if ($mailer->send()){
                $emailEntity->sent = 1;
            } else {
                $emailEntity->error = $mail->ErrorInfo ?? '-';
            }
            $emailEntity->smtp_log = self::$smtpDebug;

        } catch (\Exception $e) {
            $emailEntity->error = $e->getMessage();
        }

        $emailEntity->store();

        return $emailEntity->sent ?? 0;
    }

    public function loadPreviousEmail($id)
    {
        $emailEntity = new emailEntity();
        $emailEntity->load($id);
        if (isset($emailEntity->id) && $emailEntity->id > 0) {
            $emailEntity->config = json_decode($emailEntity->config);
        }

        return $emailEntity;
    }

}
