<?php

namespace apexl\Io\modules\email;

use apexl\Io\includes\Module;
use apexl\Io\modules\email\controllers\emailController;
use apexl\Io\modules\email\entities\emailEntity;
use apexl\Io\modules\user\classes\userManagedApiModule;

class emailModule extends userManagedApiModule {

    public function __construct()
    {
        parent::__construct();
    }

    public function routes(){

        $this->addProtectedDataRoute('get', 'email.data.basic', 'data/basic', emailController::class.':emailListTableDataBasic', 'administer');

        $this->addProtectedActionRoute('post', 'email.send', 'email/send', emailController::class.':submitEmail', 'administer');
        $this->addProtectedActionRoute('post', 'email.resend', 'email/resend/{id}', emailController::class.':resendEmail', 'administer');

    }

}