<?php

namespace apexl\Io\modules\file\entities;

use apexl\Io\includes\Entity;
use apexl\Io\includes\System;
use apexl\Io\modules\file\entities\operators\fileOperator;
use apexl\Io\modules\file\services\File;
use apexl\Io\operators\entityDatabaseOperator;

class fileEntity extends Entity
{
    /** @var File */
    public $fileService;

    public function __construct()
    {
        parent::__construct('files', 'id');
        $this->setOperator(new fileOperator('files', 'id'));
        $this->setRequiredData(['entity_id', 'entity_type', 'path']);
        $this->fileService = File::getInstance();
    }

    public function downloadFilePath()
    {
        return $this->path;
    }

    /**
     * function to get the full local file path of the file.
     * @return string
     */
    public function getLocalPath()
    {
        return System::getBasePath().DIRECTORY_SEPARATOR.$this->path;
    }

    public function delete($id = null): Entity
    {
        //unlink the attached file
        unlink(System::getBasePath().DIRECTORY_SEPARATOR.$this->data['path']);
        parent::delete($id);
    }
}
