<?php

namespace apexl\Io\modules\file;

use apexl\Io\includes\System;
use apexl\Io\modules\file\controllers\fileController;
use apexl\Io\modules\file\services\File;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\controllers\userDisplayController;
use apexl\Io\modules\user\services\Permissions;

class fileModule extends userManagedApiModule
{
    public function __construct()
    {
        parent::__construct();
        $this->permissions();
    }

    public function routes()
    {
        $this->addProtectedActionRoute('POST', 'files.core.upload', 'upload[/{id}]', fileController::class.':files', 'UploadFiles');
        $this->addProtectedActionRoute('GET', 'files.core.download', 'download[/{id}]', fileController::class.':download', 'DownloadFiles');
    }

    protected function permissions()
    {
        $permissions = Permissions::getInstance();
        $permissions->registerPermission('UploadFiles', 'Can Upload Files', 'Files');
        $permissions->registerPermission('DownloadFiles', 'Can Download Files', 'Files');
    }

    public function addServices()
    {
        return [
            File::class => function () {
                return File::getInstance();
            }
        ];
    }

    public function schema()
    {
        return System::loadSchema(__DIR__.'/schema/schema.json');
    }
}
