<?php
declare(strict_types=1);

use Phinx\Db\Adapter\AdapterInterface;
use Phinx\Migration\AbstractMigration;

final class CreateFilesTable extends AbstractMigration
{
    /**
     * Change Method.
     *
     * Write your reversible migrations using this method.
     *
     * More information on writing migrations is available here:
     * https://book.cakephp.org/phinx/0/en/migrations.html#the-change-method
     *
     * Remember to call "create()" or "update()" and NOT "save()" when working
     * with the Table class.
     */
    public function change(): void
    {
        $this->table('files')
            ->addColumn('name', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('path', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('mime', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
            ])
            ->addColumn('access_perm', AdapterInterface::PHINX_TYPE_STRING, [
                'null' => false,
                'default' => 'AllowAll',
            ])
            ->addColumn('created', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addColumn('created_by', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addColumn('modified', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addColumn('modified_by', AdapterInterface::PHINX_TYPE_INTEGER)
            ->addIndex('name')
            ->addIndex('mime')
            ->create();
    }
}
