<?php

namespace apexl\Io\modules\file;

use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\file\controllers\fileController;
use apexl\Io\modules\file\services\File;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\services\Permissions;

class fileModule extends userManagedApiModule implements HasServicesInterface
{
    public function __construct()
    {
        parent::__construct();
        $this->permissions();
    }

    protected function permissions()
    {
        $permissions = Permissions::getInstance();
        $permissions->registerPermission('UploadFiles', 'Can Upload Files', 'Files');
    }

    public function routes(): void
    {
        $this->addProtectedActionRoute(
            'POST',
            'files.core.upload',
            'upload[/{id}]',
            fileController::class.':files',
            'UploadFiles'
        );
    }

    public function addServices(): array
    {
        return [
            File::class => function () {
                return File::getInstance();
            },
        ];
    }
}
