<?php

namespace apexl\Io\modules\file;

use apexl\Io\enums\HttpMethod;
use apexl\Io\includes\RouteManager;
use apexl\Io\modules\file\controllers\fileController;
use apexl\Io\modules\system\interfaces\ProvidesRoutesInterface;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\interfaces\ProvidesPermissionsInterface;
use apexl\Io\modules\user\services\Permissions;
use apexl\Io\services\InstallChecker;

final class fileModule extends userManagedApiModule implements ProvidesRoutesInterface, ProvidesPermissionsInterface
{
    public function __construct(
        InstallChecker $installChecker,

    ) {
        parent::__construct($installChecker);
    }

    public function permissions(Permissions $permissions): void
    {
        $permissions->registerPermission(
            enums\permissions\File::UPLOAD_FILES,
            'Can Upload Files',
            'Files'
        );
    }

    public function routes(RouteManager $routeManager): void
    {
        $this->addProtectedActionRoute(
            $routeManager,
            HttpMethod::POST,
            'files.core.upload',
            'upload[/{id}]',
            fileController::class,
            enums\permissions\File::UPLOAD_FILES,
        );
    }
}
