<?php

namespace apexl\Io\modules\file\controllers;

use apexl\Io\includes\Controller;
use apexl\Io\modules\file\services\File;
use apexl\Io\services\Output;
use Exception;
use Psr\Http\Message\ResponseInterface as Response;
use Psr\Http\Message\ServerRequestInterface as Request;

final readonly class fileController extends Controller
{
    public function __construct(
        protected File $file,
        Output $output,
    ) {
        parent::__construct($output);
    }

    /**
     * Generic file store method. Returns file entity data
     * @throws Exception
     */
    public function __invoke(Request $request, Response $response): Response
    {
        $fileEntity = $this->file::getFileFromUpload($request);
        //Check we have a file we're allowed to upload and store, if not, throw an error
        if (!$this->file::isTypeAllowed($fileEntity->mime, $this->file::DEFAULT_ALLOWED_TYPES)) {
            $this->output::addMessage(
                'core.file.upload',
                'error',
                'File type of ' . $fileEntity->mime . ' not allowed'
            );

            return $this->json($response, [], 403);
        }

        $path = $this->file::storeUploadedFile($fileEntity->getMetadata('uploadedFile'));
        $fileEntity->path = $path;
        $fileEntity->store();

        $this->output::addMessage('core.file.upload', 'success', 'File type of ' . $fileEntity->mime . ' uploaded.');
        $this->output::addResponse($request, ['fid' => $fileEntity->id]);

        return $this->json($response);
    }
}
