<?php

namespace apexl\Io\modules\file;

use apexl\Io\enums\HttpMethod;
use apexl\Io\interfaces\HasServicesInterface;
use apexl\Io\modules\file\controllers\fileController;
use apexl\Io\modules\file\services\File;
use apexl\Io\modules\user\classes\userManagedApiModule;
use apexl\Io\modules\user\services\Permissions;

final class fileModule extends userManagedApiModule implements HasServicesInterface
{
    public function __construct(private readonly Permissions $permissions)
    {
        parent::__construct();
        $this->permissions();
    }

    protected function permissions(): void
    {
        $this->permissions->registerPermission(
            enums\permissions\File::UPLOAD_FILES,
            'Can Upload Files',
            'Files'
        );
    }

    public function routes(): void
    {
        $this->addProtectedActionRoute(
            HttpMethod::POST,
            'files.core.upload',
            'upload[/{id}]',
            fileController::class,
            enums\permissions\File::UPLOAD_FILES,
        );
    }

    public function addServices(): array
    {
        return [
            File::class => function () {
                return File::getInstance();
            },
        ];
    }
}
