<?php

declare(strict_types=1);

namespace apexl\Io\modules\file\interfaces;

use apexl\Io\modules\file\entities\fileEntity;
use Slim\Psr7\UploadedFile;

interface FileServiceInterface
{
    public function storeUploadedFile(
        UploadedFile $uploadedFile,
        string $directory = 'uploads',
        ?string $name = null
    ): fileEntity;

    public function copyFileToUploadFolder(
        string $fromPath,
        string $directory = 'uploads',
        ?string $name = null
    ): fileEntity;

    public function storeFileFromData(string $data, string $directory = 'uploads', ?string $name = null): fileEntity;
}
