<?php

namespace apexl\Io\modules\formbuilder\includes;

use apexl\Config\Singleton;
use apexl\Io\modules\file\entities\fileEntity;

class dropzoneField extends formField
{
    public function __construct($name)
    {
        parent::__construct($name, 'dropzone', 'dropzone');

        $this->field->label = 'Drop a file here';
        $this->field->buttonText = 'Select a file from your computer';
    }

    public function setFileSavePath($savePath): dropzoneField
    {
        $config = Singleton::getInstance();

        $this->field->fileSavePath = sprintf(
            '%s%s%s',
            $config->app->site->backend_domain,
            DIRECTORY_SEPARATOR,
            ltrim(
                $savePath,
                DIRECTORY_SEPARATOR
            )
        );

        return $this;
    }

    public function setValue($value): dropzoneField
    {
        parent::setValue($value);

        if ($value !== null) {
            $file = new fileEntity();
            $file->load($value);

            $this->field->file = [
                'name' => $file->name,
                'type' => $file->mime,
                'size' => filesize($file->getLocalPath()),
            ];
        }

        return $this;
    }
}
