<?php

namespace apexl\Io\modules\formbuilder\entities;

use apexl\Io\includes\Entity;
use apexl\Io\modules\formbuilder\interfaces\formFieldInterface;
use apexl\Io\modules\formbuilder\includes\formField;

class formEntity extends Entity
{
    protected $fields;
    protected $form_details;

    protected $fieldObjects; /** @todo, do this better */

    public function __construct()
    {
        parent::__construct('forms');
        $this->fields = (object)[];
        $this->form_details  = (object)[];
        $this->callBackData = (object)[];
        $this->formVerb(); //default to POST
    }

    /**
     * @param formFieldInterface $field
     * @param bool $fieldset
     * @return $this
     */
    public function addField(formFieldInterface $field, $fieldset = false)
    {
        if ($fieldset) {
            $this->addFieldToFieldset($field, $fieldset);
        } else {
            $this->fields->{$field->field->name} = $field->field;
        }
        $this->fieldObjects[$field->field->name] = $field;
        return $this;
    }

    public function addFieldToGroup(formFieldInterface $field, $group, $fieldset = false)
    {
        $fieldGroup = 'fieldGroup_'. strtolower(str_replace('_', '', $group));
        if ($fieldset) {
            $this->addFieldGroupToFieldset($field, $fieldGroup, $fieldset);
        } else {
            $this->fields->$fieldGroup[$field->field->name] = $field->field;
        }
        return $this;
    }

    public function addFieldGroupClasses($group, $classes, $fieldset = false)
    {
        $fieldGroup = 'fieldGroup_'. strtolower(str_replace('_', '', $group));
        if ($fieldset) {
            $fieldsetId = $this->checkGenerateFieldset($fieldset);
            if (!isset($this->fields->$fieldsetId->$fieldGroup)) {
                $this->fields->$fieldsetId->$fieldGroup = (object)[];
            }
            $this->fields->$fieldsetId->$fieldGroup->{'__classes'} = $classes;
        } else {
            if (!isset($this->fields->$fieldGroup)) {
                $this->fields->$fieldGroup = (object)[];
            }
            $this->fields->$fieldGroup->{'__classes'} = $classes;
        }
        return $this;
    }

    public function addFieldGroupToFieldset($field, $fieldGroup, $fieldset = false)
    {
        $fieldsetId = $this->checkGenerateFieldset($fieldset);
        if (!isset($this->fields->$fieldsetId->$fieldGroup)) {
            $this->fields->$fieldsetId->$fieldGroup = (object)[];
        }
        $this->fields->$fieldsetId->$fieldGroup->{$field->field->name} = $field->field;
        return $this;
    }

    public function addFieldToFieldset($field, $fieldset = false)
    {
        $fieldsetId = $this->checkGenerateFieldset($fieldset);
        $this->fields->$fieldsetId->{$field->field->name} = $field->field;
        return $this;
    }

    protected function checkGenerateFieldset($fieldset)
    {
        $fieldsetId = 'fieldset_'. strtolower(str_replace('_', '', $fieldset));
        if (!isset($this->fields->$fieldsetId)) {
            $this->fields->$fieldsetId = (object)[];
        }
        return $fieldsetId;
    }

    public function setFieldsetSetting($fieldset, $setting, $value)
    {
        $fieldsetId = $this->checkGenerateFieldset($fieldset);
        if (!isset($this->fields->$fieldsetId->fieldset_settings)) {
            $this->fields->$fieldsetId->fieldset_settings = (object)[];
        }
        $this->fields->$fieldsetId->fieldset_settings->$setting = $value;
    }

    public function setId($id)
    {
        $this->form_details->id = $id;
        return $this;
    }

    public function addClass($class)
    {
        $this->form_details->classes[] = $class;
        return $this;
    }

    public function setMethod($method)
    {
        $this->formVerb($method);
        return $this;
    }

    public function setActionUrl($action)
    {
        $this->form_details->action = $action;
        return $this;
    }

    public function setSubmitText($text)
    {
        $this->form_details->submitText = $text;
        return $this;
    }

    public function setSubmitIcon($iconMarkup)
    {
        $this->form_details->submitIcon = $iconMarkup;
        return $this;
    }

    public function includeClearButton($include = true)
    {
        $this->form_details->clearButton = $include;
        return $this;
    }

    public function setClearButtonText($text)
    {
        $this->form_details->clearButtonText = $text;
        return $this;
    }

    public function removeSubmitButton($remove = true)
    {
        $this->form_details->removeSubmit = $remove;
        return $this;
    }

    public function submitAsFormData($asFormData = true)
    {
        $this->form_details->isFormData = $asFormData;
        return $this;
    }

    /**
     * Since api forms could use Axios, we can set non traditional HTTP Verbs for form submission.
     * @param bool $verb
     * @return $this
     */
    public function formVerb($verb = 'POST')
    {
        $this->form_details->verb = strtoupper($verb);
        return $this;
    }

    public function getFields()
    {
        return $this->fields;
    }

    public function getDetails()
    {
        return $this->form_details;
    }

    /**
     * @param $name
     * @return false
     */
    public function getFormField($name)
    {
        return $this->fieldObjects[$name] ?? false;
    }

    public function deleteField($name)
    {
        unset($this->fields->$name);
        return $this;
    }

    public function getBuiltFormArray()
    {
        return ["form" => ["details" => $this->form_details, "fields" => $this->fields, "callBackData" => $this->callBackData]];
    }

    public function getAsJson()
    {
        return json_encode((object)$this->data);
    }

    public function addCallbackData($fieldName, $data)
    {
        $this->callBackData->$fieldName = $data;
        return $this;
    }

    /**
     * Override the store method to account for config data etc.
     * @return Entity
     * @throws \Exception
     */
    public function store(): Entity{
        //we need to retain the object to ensure we gain any ids on store, so we encode and then decode, rather than clone.

        $cleanVersion = $this->data['roles'];
        $this->data['roles'] = serialize($this->data['roles']);
        parent::store();
        $this->data['roles'] = $cleanVersion;

        // if this is an array at this point, then its empty and has no values, so set it to null.
        if(is_array($this->data['roles'])){
            $this->data['roles'] = null;
        }
        parent::store();
        return $this;
    }
}
