<?php

namespace apexl\Io\modules\formbuilder\includes;

use apexl\Io\modules\formbuilder\includes\formField;

class numberField extends formField
{
    public function __construct($name)
    {
        parent::__construct($name, 'input', 'number');
    }

    public function setValue($value){ // this is required to fix the VueJS bug, where 0 values are being converted to empty strings
        if (is_numeric($value)) $value = (string)$value;
        $this->field->value = $value;
        return $this;
    }

    public function setStep($decimals)
    {
        switch ($decimals){
            case 1:
                $this->field->step = ".1";
                break;
            case 2:
                $this->field->step = ".01";
                break;
            case 3:
                $this->field->step = ".001";
                break;
            case 4:
                $this->field->step = ".0001";
                break;
            case 5:
                $this->field->step = ".00001";
                break;
        }

        return $this;
    }
}