<?php

namespace apexl\Io\modules\formbuilder\includes;

use apexl\Config\Singleton;
use apexl\Io\modules\file\entities\fileEntity;

class photoCaptureField extends formField
{
    public function __construct($name)
    {
        parent::__construct($name, 'photoCapture', 'file');

        $this->field->label = 'Take a photo of yourself';
        $this->field->buttonText = 'Take photo now';
    }

    public function setFileSavePath($savePath)
    {
        $config = Singleton::getInstance();

        $this->field->fileSavePath = sprintf(
            '%s%s%s',
            $config->app->site->backend_domain,
            DIRECTORY_SEPARATOR,
            ltrim(
                $savePath,
                DIRECTORY_SEPARATOR
            )
        );

        return $this;
    }

    public function setValue($value)
    {
        parent::setValue($value);

        if ($value !== null) {
            $file = new fileEntity();
            $file->load($value);

            $this->field->file = [
                'name' => $file->name,
                'type' => $file->mime,
                'size' => filesize($file->getLocalPath()),
            ];
        }

        return $this;
    }
}
