<?php

namespace apexl\Io\modules\formbuilder\includes;

use apexl\Config\Singleton;
use apexl\Io\modules\file\entities\fileEntity;
use apexl\Io\services\HttpPaths;

class dropzoneField extends formField
{
    public function __construct($name)
    {
        parent::__construct($name, 'dropzone', 'dropzone');

        $this->field->label = 'Drop a file here';
        $this->field->buttonText = 'Select a file from your computer';
    }

    public function setFileSavePath($savePath): dropzoneField
    {
        $httpPaths = container()->get(HttpPaths::class);
        $this->field->fileSavePath = $httpPaths->backendUrl($savePath);

        return $this;
    }

    public function setValue($value): dropzoneField
    {
        parent::setValue($value);

        if ($value !== null) {
            $file = new fileEntity();
            $file->load($value);

            $this->field->file = [
                'name' => $file->name,
                'type' => $file->mime,
                'size' => filesize($file->getLocalPath()),
            ];
        }

        return $this;
    }
}
