<?php

declare(strict_types=1);

namespace apexl\Io\modules\formbuilder\ComponentFactories;

use apexl\Io\modules\component\Factories\GenericComponentFactory;
use apexl\Io\modules\formbuilder\Components\FormKitField\FormKitField;

final readonly class FormFieldComponentFactory
{
    public function __construct(
        private GenericComponentFactory $componentFactory,
    ) {}

    /**
     * @param class-string<FormKitField> $class
     */
    public function make(string $class, string $fieldName): FormKitField
    {
        assert(
            is_a($class, FormKitField::class, true),
            sprintf('`%s` must be instanceof `%s`', $class, FormKitField::class)
        );

        /** @var FormKitField $field */
        $field = $this->componentFactory->make($class, constructorParams: [
            'fieldName' => $fieldName
        ]);

        return $field;
    }
}